<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Candidate Profile - Premium Theme</title>
    
    <!-- Google Fonts - Matching premium-site -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Space+Grotesk:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <link rel="icon" type="image/png" href="logo-h.png">
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="container">
    <!-- Top Navigation Bar -->
    <header class="menu-bar">
        <a href="#" class="menu-logo">
            <img src="logo-h.png" alt="MFStrive" class="logo-img">
        </a>
        <nav class="top-nav">
            <div class="nav-container">
            <a href="#" class="nav-item">
                <span class="nav-icon-wrapper">
                    <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                        <polyline points="9 22 9 12 15 12 15 22"/>
                    </svg>
                    <span class="nav-notification-dot"></span>
                </span>
                <span class="nav-label">Home</span>
            </a>
            <a href="#" class="nav-item">
                <span class="nav-icon-wrapper">
                    <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"/>
                        <path d="M13.73 21a2 2 0 0 1-3.46 0"/>
                    </svg>
                </span>
                <span class="nav-label">Notifications</span>
            </a>
            <a href="#" class="nav-item">
                <span class="nav-icon-wrapper">
                    <svg class="nav-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <rect x="2" y="7" width="20" height="14" rx="2" ry="2"/>
                        <path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16"/>
                    </svg>
                </span>
                <span class="nav-label">Applied Jobs</span>
            </a>
            <div class="nav-item nav-item-me" id="navMe">
                <span class="nav-icon-wrapper">
                    <div class="nav-profile-pic">
                        <div class="profile-initial">EA</div>
                    </div>
                    <svg class="nav-chevron" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="6 9 12 15 18 9"/>
                    </svg>
                </span>
                <span class="nav-label">Me</span>
                <!-- Me Dropdown -->
                <div class="me-dropdown" id="meDropdown">
                    <div class="me-dropdown-profile">
                        <div class="me-dropdown-avatar">
                            <div class="profile-initial">EA</div>
                        </div>
                        <div class="me-dropdown-info">
                            <h3 class="me-dropdown-name">Esha Akram</h3>
                            <p class="me-dropdown-title">Software Engineer | Full-Stack Developer | ReactJS | PHP | NodeJS | JavaScript</p>
                            <div class="me-dropdown-buttons">
                                <button class="btn-view-profile">Edit profile</button>
                                <button class="btn-verify">Verify</button>
                            </div>
                        </div>
                    </div>
                    <div class="me-dropdown-section">
                        <h4 class="me-dropdown-heading">Account</h4>
                        <a href="#" class="me-dropdown-link">
                            <span class="me-dropdown-link-icon diamond">◆</span>
                            Premium features
                        </a>
                        <a href="#" class="me-dropdown-link">Settings & Privacy</a>
                        <a href="#" class="me-dropdown-link">Help</a>
                    </div>
                    <div class="me-dropdown-section me-dropdown-signout">
                        <a href="#" class="me-dropdown-link">Sign Out</a>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    </header>
        <!-- Profile Header Section -->
        <div class="profile-header">
            <div class="banner">
                <img src="https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=1200&h=300&fit=crop" alt="Banner" class="banner-image">
            </div>
            <div class="profile-info">
                <div class="profile-picture-container">
                    <div class="profile-picture">
                        <div class="profile-logo">EA</div>
                    </div>
                    <div class="open-to-work-badge">#OPENTOWORK</div>
                </div>
                <div class="profile-details">
                    <h1 class="profile-name">Esha Akram <span class="connection-badge">· 2nd</span></h1>
                    <div class="profile-headline-row">
                        <p class="profile-headline">Software Engineer | Full-Stack Developer | ReactJS | PHP | NodeJS | JavaScript | HTML | CSS | MongoDB | MySQL | Firebase</p>
                        <div class="score-badge">
                            <span class="score-rating">8/10</span>
                            <span class="score-points">10245 points</span>
                        </div>
                    </div>
                    <div class="location-info">
                        <span>Malikpur, Faisalabad</span>
                        <a href="#" class="contact-link">Contact info</a>
                    </div>
                    <div class="open-to-work-box">
                        <strong>Open to work</strong>
                        <p>Software Engineer, Full-Stack Developer and Web Developer roles</p>
                        <a href="#" class="show-details">Show details</a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Content Layout: Main + Sidebar -->
        <div class="content-layout">
            <!-- Main Content -->
            <div class="main-content">
            <!-- About Section -->
            <div class="section-card">
                <h2 class="section-title">About</h2>
                <div class="about-content">
                    <p>Software Engineering graduate from National Textile University with experience in full-stack development. Skilled in ReactJS, PHP, NodeJS, JavaScript, and databases (MySQL, MongoDB, Firebase). Passionate about building web applications with clean architecture and user-focused design.</p>
                    <p class="about-text-collapsed">Experienced in RESTful APIs, MVC, and Agile methodologies. Proficient with VS Code, Postman, GitHub, JIRA, Slack, and Figma. Strong soft skills in leadership, communication, and problem-solving. Volunteer experience leading teams in SE Society and WOH Society.</p>
                    <button class="see-more-btn" onclick="toggleAbout()">...see more</button>
                </div>
                <div class="top-skills-card">
                    <div class="top-skills-header">
                        <span class="diamond-icon">◆</span>
                        <h3 class="top-skills-title">Top skills</h3>
                        <span class="arrow-icon">→</span>
                    </div>
                    <div class="top-skills-list">
                        <span>ReactJS</span>
                        <span class="bullet">•</span>
                        <span>JavaScript</span>
                        <span class="bullet">•</span>
                        <span>PHP</span>
                        <span class="bullet">•</span>
                        <span>NodeJS</span>
                    </div>
                </div>
            </div>

            <!-- Experience Section -->
            <div class="section-card">
                <h2 class="section-title">Experience</h2>
                <div class="experience-item">
                    <div class="experience-header">
                        <div class="company-logo">
                            <div class="logo-placeholder">V</div>
                        </div>
                        <div class="experience-details">
                            <h3 class="job-title">Junior Web Application Developer & Intern</h3>
                            <p class="company-name">V3 Solutions · Internship</p>
                            <p class="duration">Jul 2023 - Oct 2023 · 4 mos</p>
                            <p class="location">NTRC FSD</p>
                            <div class="experience-skills">
                                <span class="diamond-icon">◆</span>
                                <span>JavaScript, ReactJS, API integration, Routing, SSOT</span>
                            </div>
                            <p class="experience-desc">Developed various projects using JavaScript/React including landing pages, theme changes, Todo Apps, and task management application with API integration and React Router for dynamic navigation.</p>
                        </div>
                    </div>
                </div>
                <div class="experience-item">
                    <div class="experience-header">
                        <div class="company-logo">
                            <div class="logo-placeholder">K</div>
                        </div>
                        <div class="experience-details">
                            <h3 class="job-title">Intern</h3>
                            <p class="company-name">Klash Private Limited · Internship</p>
                            <p class="duration">Aug 2022 - Sept 2022 · 2 mos</p>
                            <p class="location">FSD</p>
                            <div class="experience-skills">
                                <span class="diamond-icon">◆</span>
                                <span>SQL, Oracle Forms, Oracle Reports</span>
                            </div>
                            <p class="experience-desc">Created and customized Oracle Forms to streamline user input and data management. Generated comprehensive Oracle Reports for data analysis and decision-making.</p>
                        </div>
                    </div>
                </div>
                <div class="experience-item">
                    <div class="experience-header">
                        <div class="company-logo">
                            <div class="logo-placeholder">E</div>
                        </div>
                        <div class="experience-details">
                            <h3 class="job-title">Intern</h3>
                            <p class="company-name">Eyesome Studios · Internship</p>
                            <p class="duration">Mar 2021 - Apr 2021 · 2 mos</p>
                            <p class="location">Online</p>
                            <div class="experience-skills">
                                <span class="diamond-icon">◆</span>
                                <span>WordPress, Video Editing, Blogs Writing</span>
                            </div>
                            <p class="experience-desc">Developed and managed WordPress websites with responsive design. Edited cooking videos and wrote recipes. Worked on aansakitchen.co.uk</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Assessment Tests Section -->
            <div class="section-card">
                <h2 class="section-title">
                    
                    <span class="section-title-text">Assessment tests</span>
                    <a href="#" class="re-appear-link">Re-Attempt</a>
                </h2>
                <div class="assessment-cards-grid">
                    <div class="assessment-card">
                        <div class="assessment-card-icon react-icon">
                            <svg viewBox="-11.5 -10.23174 23 20.46348"><circle r="2.05" fill="currentColor"/><g stroke="currentColor" stroke-width="1" fill="none"><ellipse rx="11" ry="4.2"/><ellipse rx="11" ry="4.2" transform="rotate(60)"/><ellipse rx="11" ry="4.2" transform="rotate(120)"/></g></svg>
                        </div>
                        <h3 class="assessment-card-skill">React</h3>
                        <div class="assessment-card-score">
                            <span class="score-value">60</span>
                            <span class="score-out-of">/ 100</span>
                        </div>
                        <div class="assessment-card-progress">
                            <div class="progress-bar" style="--progress: 60%"></div>
                        </div>
                        <span class="assessment-card-badge">60%</span>
                    </div>
                    <div class="assessment-card">
                        <div class="assessment-card-icon html-icon">
                            <svg viewBox="0 0 24 24" fill="currentColor"><path d="M1.5 0h21l-1.91 21.563L11.977 24l-8.565-2.438L1.5 0zm7.031 9.75-.232-2.718 10.059.003.23-2.622L5.412 4.41l.698 8.01h9.126l-.326 3.426-2.91.804-2.955-.81-.188-2.11H6.248l.33 4.171L12 19.351l5.379-1.443.744-8.157H8.531z"/></svg>
                        </div>
                        <h3 class="assessment-card-skill">HTML</h3>
                        <div class="assessment-card-score">
                            <span class="score-value">70</span>
                            <span class="score-out-of">/ 100</span>
                        </div>
                        <div class="assessment-card-progress">
                            <div class="progress-bar" style="--progress: 70%"></div>
                        </div>
                        <span class="assessment-card-badge">70%</span>
                    </div>
                </div>
            </div>

            <!-- Education Section -->
            <div class="section-card">
                <h2 class="section-title">Education</h2>
                <div class="education-item">
                    <div class="education-header">
                        <div class="university-logo">
                            <div class="logo-crest">🛡️</div>
                        </div>
                        <div class="education-details">
                            <h3 class="university-name">National Textile University</h3>
                            <p class="degree">B.S., Software Engineering</p>
                            <p class="duration">Oct 2020 - Jul 2024 · FSD</p>
                            <p class="grade">CGPA: 3.29</p>
                            <div class="education-skills">
                                <span class="diamond-icon">◆</span>
                                <span>Flutter, PHP, ReactJS, Python, C#, .NET and more</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="education-item">
                    <div class="education-header">
                        <div class="university-logo">
                            <div class="logo-crest">🛡️</div>
                        </div>
                        <div class="education-details">
                            <h3 class="university-name">ILM College</h3>
                            <p class="degree">I.C.S., Computer Science</p>
                            <p class="duration">Oct 2018 - Jul 2020 · Malikpur</p>
                            <p class="grade">Grade: 82%</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Skills Section -->
            <div class="section-card">
                <h2 class="section-title">Skills</h2>
                <div class="skills-list">
                    <div class="skill-item">
                        <div class="skill-content">
                            <h3 class="skill-name">ReactJS</h3>
                            <div class="skill-institution">
                                <div class="institution-logo">🛡️</div>
                                <span>National Textile University</span>
                            </div>
                        </div>
                    </div>
                    <div class="skill-divider"></div>
                    <div class="skill-item">
                        <div class="skill-content">
                            <h3 class="skill-name">PHP</h3>
                            <div class="skill-institution">
                                <div class="institution-logo">🛡️</div>
                                <span>National Textile University</span>
                            </div>
                        </div>
                    </div>
                    <div class="skill-divider"></div>
                    <div class="skill-item">
                        <div class="skill-content">
                            <h3 class="skill-name">NodeJS</h3>
                            <div class="skill-institution">
                                <div class="institution-logo">🛡️</div>
                                <span>National Textile University</span>
                            </div>
                        </div>
                    </div>
                    <div class="skill-divider"></div>
                    <div class="show-all-skills">
                        <a href="#" class="show-all-link">Show all 14 skills →</a>
                    </div>
                </div>
            </div>

            <!-- Licenses & Certifications Section -->
            <div class="section-card">
                <h2 class="section-title">Licenses & certifications</h2>
                <div class="certifications-list">
                    <div class="certification-item">
                        <div class="certification-header">
                            <div class="cert-logo">
                                <div class="cert-logo-placeholder">📊</div>
                            </div>
                            <div class="cert-details">
                                <h3 class="cert-title">Web Development & WordPress</h3>
                                <p class="cert-issuer">NFTP</p>
                                <p class="cert-date">Issued Mar 2023</p>
                                <div class="cert-skill">
                                    <span class="diamond-icon">◆</span>
                                    <span>Web Development, WordPress</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="cert-divider"></div>
                    <div class="certification-item">
                        <div class="certification-header">
                            <div class="cert-logo">
                                <div class="cert-logo-placeholder">📊</div>
                            </div>
                            <div class="cert-details">
                                <h3 class="cert-title">Communication Skills</h3>
                                <p class="cert-issuer">Tutify</p>
                                <p class="cert-date">Issued Jul 2021</p>
                                <div class="cert-skill">
                                    <span class="diamond-icon">◆</span>
                                    <span>Communication</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="cert-divider"></div>
                    <div class="certification-item">
                        <div class="certification-header">
                            <div class="cert-logo">
                                <div class="cert-logo-placeholder">📊</div>
                            </div>
                            <div class="cert-details">
                                <h3 class="cert-title">Graphic Design - Adobe Photoshop</h3>
                                <p class="cert-issuer">CoursVork</p>
                                <p class="cert-date">Issued May 2021</p>
                                <div class="cert-skill">
                                    <span class="diamond-icon">◆</span>
                                    <span>Adobe Photoshop, Graphic Design</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="cert-divider"></div>
                    <div class="show-all-certifications">
                        <a href="#" class="show-all-link">Show all 3 licenses & certifications →</a>
                    </div>
                </div>
            </div>
        </div>

            <!-- Right Sidebar Column -->
            <div class="right-sidebar-column">
            <aside class="right-sidebar">
                <h2 class="sidebar-title">More companies for you</h2>
                <div class="company-list">
                    <div class="company-card">
                        <div class="company-avatar">
                            <div class="company-logo-placeholder">T</div>
                        </div>
                        <div class="company-info">
                            <h3 class="company-name">TechCorp Solutions</h3>
                            <p class="company-jobs">10+ Jobs Openings</p>
                            <button class="btn-apply"><span class="btn-apply-icon">→</span> Apply Now</button>
                        </div>
                    </div>
                    <div class="company-divider"></div>
                    <div class="company-card">
                        <div class="company-avatar">
                            <div class="company-logo-placeholder">D</div>
                        </div>
                        <div class="company-info">
                            <h3 class="company-name">Digital Ventures</h3>
                            <p class="company-jobs">5+ Jobs Openings</p>
                            <button class="btn-apply"><span class="btn-apply-icon">→</span> Apply Now</button>
                        </div>
                    </div>
                    <div class="company-divider"></div>
                    <div class="company-card">
                        <div class="company-avatar">
                            <div class="company-logo-placeholder">I</div>
                        </div>
                        <div class="company-info">
                            <h3 class="company-name">Innovate Labs</h3>
                            <p class="company-jobs">8+ Jobs Openings</p>
                            <button class="btn-apply"><span class="btn-apply-icon">→</span> Apply Now</button>
                        </div>
                    </div>
                </div>
            </aside>

            <!-- Right Sidebar - Skills Test -->
            <aside class="skills-sidebar-box">
                <h2 class="sidebar-title">Skills</h2>
                <div class="skill-test-list">
                    <div class="skill-test-card">
                        <div class="skill-test-avatar skill-logo react-logo">
                            <svg viewBox="-11.5 -10.23174 23 20.46348"><circle r="2.05" fill="currentColor"/><g stroke="currentColor" stroke-width="1" fill="none"><ellipse rx="11" ry="4.2"/><ellipse rx="11" ry="4.2" transform="rotate(60)"/><ellipse rx="11" ry="4.2" transform="rotate(120)"/></g></svg>
                        </div>
                        <div class="skill-test-info">
                            <h3 class="skill-test-name">React</h3>
                            <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                        </div>
                    </div>
                    <div class="skill-test-divider"></div>
                    <div class="skill-test-card">
                        <div class="skill-test-avatar skill-logo html-logo">
                            <svg viewBox="0 0 24 24" fill="currentColor"><path d="M1.5 0h21l-1.91 21.563L11.977 24l-8.565-2.438L1.5 0zm7.031 9.75-.232-2.718 10.059.003.23-2.622L5.412 4.41l.698 8.01h9.126l-.326 3.426-2.91.804-2.955-.81-.188-2.11H6.248l.33 4.171L12 19.351l5.379-1.443.744-8.157H8.531z"/></svg>
                        </div>
                        <div class="skill-test-info">
                            <h3 class="skill-test-name">HTML</h3>
                            <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                        </div>
                    </div>
                    <div class="skill-test-divider"></div>
                    <div class="skill-test-card">
                        <div class="skill-test-avatar skill-logo dotnet-logo">
                            <svg viewBox="0 0 24 24" fill="currentColor"><path d="M3.972 2.08a.174.174 0 0 0-.152.087L.763 7.127a.174.174 0 0 0 .152.26h1.453a.174.174 0 0 0 .151-.088l.307-.528a.174.174 0 0 1 .152-.087h1.762a.174.174 0 0 1 .151.087l.306.528a.174.174 0 0 0 .152.088h1.453a.174.174 0 0 0 .152-.26L4.124 2.167a.174.174 0 0 0-.152-.087zm3.528 3.34a.174.174 0 0 0-.151.088l-2.38 4.115a.174.174 0 0 0 .152.26h1.454a.174.174 0 0 0 .151-.088l.508-.878.555.959a.174.174 0 0 0 .151.087h1.532a.174.174 0 0 0 .151-.26l-2.38-4.115a.174.174 0 0 0-.151-.088zM24 10.475l-2.473-4.257a.703.703 0 0 0-.613-.355h-1.381a.352.352 0 0 0-.304.177l-3.207 5.546 3.207 5.548a.352.352 0 0 0 .304.176h1.381a.703.703 0 0 0 .613-.355L24 13.525zm-4.341.885L17.407 7.77l-1.868 3.232 1.868 3.232zM12.507 2.08a.174.174 0 0 0-.152.087L9.298 7.127a.174.174 0 0 0 .152.26h1.454a.174.174 0 0 0 .151-.088l.307-.528a.174.174 0 0 1 .152-.087h1.762a.174.174 0 0 1 .151.087l.306.528a.174.174 0 0 0 .152.088h1.454a.174.174 0 0 0 .152-.26L12.66 2.167a.174.174 0 0 0-.152-.087z"/></svg>
                        </div>
                        <div class="skill-test-info">
                            <h3 class="skill-test-name">.Net</h3>
                            <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                        </div>
                    </div>
                    <div class="skill-test-divider"></div>
                    <div class="skill-test-card">
                        <div class="skill-test-avatar skill-logo js-logo">
                            <svg viewBox="0 0 24 24" fill="currentColor"><path d="M0 0h24v24H0V0zm22.034 18.276c-.175-1.095-.888-2.015-3.003-2.873-.736-.345-1.554-.585-1.797-1.14-.091-.33-.105-.51-.046-.705.15-.646.913-.84 1.515-.66.39.12 1.652.42 2.86 1.376 0 0 .548.41.945.646-.225.473-.116.804.05 1.018.5.726 1.68.566 2.42.384.485-.129 1.086-.465 1.603-.979.265-.264.455-.534.665-.988.19-.406.034-.808-.247-.957-.516-.27-1.137-.195-1.659.082l-.118-.177c-.202-.255-.36-.487-.61-.697-.754-.66-2.12-.418-2.976.309-.36.38-.597.865-.637 1.374zm-8.976-12.64c-.2.169-.468.423-.773.702-1.338 1.233-3.17 2.33-5.5 2.33H2.186v-.357h.646c1.135 0 2.59-.488 3.615-1.237l.245-.213-.503-.66c-.96-1.265-2.374-2.132-3.972-2.132H1.138V9.86h.682c.985 0 1.923.25 2.793.692-.137.166-.283.332-.427.487-1.3 1.345-3.108 2.317-4.845 2.317h-.729v.357h.729c2.207 0 4.389-1.1 5.944-2.953.277-.334.569-.695.799-1.015.565-.76.97-1.44 1.156-1.914.126-.325.117-.487-.042-.628z"/></svg>
                        </div>
                        <div class="skill-test-info">
                            <h3 class="skill-test-name">JavaScript</h3>
                            <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                        </div>
                    </div>
                    <div class="skill-test-divider"></div>
                    <div class="skill-test-card">
                        <div class="skill-test-avatar skill-logo aws-logo">
                            <svg viewBox="0 0 24 24" fill="currentColor"><path d="M6.763 10.036c0 .296.032.535.088.711.064.24.16.455.256.639.128.32.304.583.487.783.272.304.6.512.95.607.32.088.688.128 1.023.128.368 0 .72-.064 1.047-.224.304-.16.567-.375.783-.663.2-.288.36-.624.447-1.007.104-.368.16-.816.16-1.311 0-.535-.048-1.007-.168-1.415-.112-.408-.28-.759-.504-1.039a2.382 2.382 0 0 0-.815-.663 2.717 2.717 0 0 0-1.063-.239c-.263 0-.551.032-.83.112-.288.08-.535.167-.774.287-.24.12-.455.263-.646.423a2.693 2.693 0 0 0-.479.551h-.48l-.319-2.063h2.718c.36 0 .615-.095.775-.272.16-.176.24-.4.24-.663 0-.248-.08-.471-.24-.647-.16-.175-.415-.27-.775-.27H6.898L6.27 2.412c-.063-.375-.167-.647-.311-.823-.144-.184-.375-.288-.703-.288-.36 0-.639.12-.831.352-.193.224-.319.544-.367.944L3.47 13.652c-.048.319.048.615.272.83.224.216.52.32.863.32.36 0 .639-.104.847-.312.2-.208.312-.487.328-.831l.375-2.423c.215.39.455.711.743.967.279.255.614.447 1.006.567.39.119.838.183 1.358.183.535 0 1.031-.088 1.463-.263.432-.176.799-.423 1.1-.735.296-.313.527-.679.686-1.111.16-.432.247-.903.247-1.415 0-.567-.08-1.063-.255-1.471a2.807 2.807 0 0 0-.735-1.063 3.04 3.04 0 0 0-1.126-.591 4.712 4.712 0 0 0-1.43-.216 4.97 4.97 0 0 0-1.35.184 3.041 3.041 0 0 0-1.127.6 2.475 2.475 0 0 0-.71.967zM12.772 7.412c.031-.351.175-.607.423-.758.24-.16.567-.24.974-.24.575 0 1.071.136 1.455.4.384.263.639.639.758 1.126.12.48.136 1 .048 1.543-.096.575-.36 1.063-.775 1.438-.415.375-.95.576-1.59.576-.311 0-.575-.04-.798-.12-.224-.08-.415-.184-.575-.312-.16-.128-.279-.272-.367-.416-.08-.151-.143-.304-.175-.471l1.366-.176zm2.166 5.83c.64 0 1.183-.136 1.615-.4.44-.271.743-.63.918-1.062.176-.431.248-.894.248-1.374 0-.471-.056-.918-.2-1.318-.128-.407-.328-.758-.6-1.038-.272-.287-.599-.503-.983-.647a3.696 3.696 0 0 0-1.295-.224c-.36 0-.711.048-1.038.136-.32.088-.615.2-.87.336-.256.135-.471.287-.639.455a1.607 1.607 0 0 0-.383.614c-.088.24-.12.495-.104.758l1.445.2c.016-.223.072-.423.168-.583.096-.16.224-.288.375-.376.16-.087.336-.136.535-.151.199-.016.407.008.606.072.2.063.375.16.527.28.16.119.279.263.375.415.096.16.16.328.192.512.04.183.056.367.056.55 0 .423-.12.758-.36 1-.239.24-.566.36-.974.36-.279 0-.518-.04-.718-.12-.2-.08-.36-.176-.487-.288-.128-.111-.224-.223-.288-.335-.063-.12-.12-.223-.151-.32l-1.447.272c.048.28.136.535.264.758.128.224.288.423.479.583.192.16.415.296.663.392.248.096.519.168.822.2.304.04.622.056.95.056zm6.004-2.166c.336 0 .63-.031.878-.104.256-.071.463-.16.623-.263.16-.104.279-.216.375-.32.096-.112.16-.216.2-.32.04-.104.064-.192.08-.263.015-.072.023-.128.031-.168.008-.04.016-.064.016-.072l-1.398-.2c-.016.111-.048.223-.088.335-.04.12-.096.224-.16.32-.063.095-.144.175-.239.238a.976.976 0 0 1-.327.152c-.128.04-.272.064-.423.064-.272 0-.471-.088-.606-.263-.136-.176-.2-.416-.2-.719 0-.183.024-.351.064-.502.048-.152.12-.288.2-.4.088-.111.184-.208.288-.279.104-.072.216-.128.335-.168.12-.04.248-.064.384-.08.136-.016.272-.024.407-.024.168 0 .335.016.495.048.16.032.312.08.455.136.144.063.272.136.384.216.112.088.2.176.272.272l1.318-.375a2.451 2.451 0 0 0-.423-.567 2.758 2.758 0 0 0-.614-.455 3.09 3.09 0 0 0-.783-.335 3.94 3.94 0 0 0-.918-.104c-.487 0-.926.088-1.301.264-.375.176-.686.415-.926.71-.239.296-.415.639-.518 1.023-.104.384-.16.8-.16 1.239 0 .455.056.87.16 1.247.104.375.264.718.47 1.015.207.296.455.535.75.718.296.184.63.312 1.006.391.376.08.775.12 1.199.12z"/></svg>
                        </div>
                        <div class="skill-test-info">
                            <h3 class="skill-test-name">AWS</h3>
                            <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                        </div>
                    </div>
                    <div class="skill-test-divider"></div>
                    <div class="skill-test-card">
                        <div class="skill-test-avatar skill-logo devops-logo">
                            <svg viewBox="0 0 24 24" fill="currentColor"><path d="M19.14 12.94c.04-.31.06-.63.06-.94 0-.31-.02-.63-.06-.94l2.03-1.58c.18-.14.23-.41.12-.61l-1.92-3.32c-.12-.22-.37-.29-.59-.22l-2.39.96c-.5-.38-1.03-.7-1.62-.94l-.36-2.54c-.04-.24-.24-.41-.48-.41h-3.84c-.24 0-.43.17-.47.41l-.36 2.54c-.59.24-1.13.57-1.62.94l-2.39-.96c-.22-.08-.47 0-.59.22L2.74 8.87c-.12.21-.08.47.12.61l2.03 1.58c-.04.31-.06.63-.06.94s.02.63.06.94l-2.03 1.58c-.18.14-.23.41-.12.61l1.92 3.32c.12.22.37.29.59.22l2.39-.96c.5.38 1.03.7 1.62.94l.36 2.54c.05.24.24.41.48.41h3.84c.24 0 .44-.17.47-.41l.36-2.54c.59-.24 1.13-.56 1.62-.94l2.39.96c.22.08.47 0 .59-.22l1.92-3.32c.12-.22.07-.47-.12-.61l-2.01-1.58zM12 15.6c-1.98 0-3.6-1.62-3.6-3.6s1.62-3.6 3.6-3.6 3.6 1.62 3.6 3.6-1.62 3.6-3.6 3.6z"/></svg>
                        </div>
                        <div class="skill-test-info">
                            <h3 class="skill-test-name">DevOps</h3>
                            <button class="btn-attempt-test"><span class="btn-attempt-icon">→</span> Attempt test</button>
                        </div>
                    </div>
                </div>
            </aside>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="site-footer">
        <div class="footer-container">
            <div class="footer-columns">
                <div class="footer-col">
                    <a href="#">About</a>
                    <a href="#">Professional Community Policies</a>
                    <a href="#">Privacy & Terms <span class="dropdown-icon">▾</span></a>
                    <a href="#">Sales Solutions</a>
                    <a href="#">Safety Center</a>
                </div>
                <div class="footer-col">
                    <a href="#">Accessibility</a>
                    <a href="#">Careers</a>
                    <a href="#">Ad Choices</a>
                    <a href="#">Mobile</a>
                </div>
                <div class="footer-col">
                    <a href="#">Talent Solutions</a>
                    <a href="#">Marketing Solutions</a>
                    <a href="#">Advertising</a>
                    <a href="#">Small Business</a>
                </div>
                <div class="footer-col footer-col-newsletter">
                    <h4 class="newsletter-title">Subscribe for newsletter</h4>
                    <p class="newsletter-subtext">Get updates on jobs and career tips.</p>
                    <form class="newsletter-form" onsubmit="return false;">
                        <input type="email" class="newsletter-input" placeholder="Enter your email" required>
                        <button type="submit" class="newsletter-btn">Subscribe</button>
                    </form>
                </div>
                <div class="footer-col footer-col-help">
                    <div class="footer-help-item">
                        <span class="footer-help-icon">
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"/><path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>
                        </span>
                        <div class="footer-help-content">
                            <span class="footer-help-title">Questions?</span>
                            <a href="#" class="footer-help-link">Visit our Help Center.</a>
                        </div>
                    </div>
                    <div class="footer-help-item">
                        <span class="footer-help-icon">
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="3"/><path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"/></svg>
                        </span>
                        <div class="footer-help-content">
                            <span class="footer-help-title">Manage your account and privacy</span>
                            <a href="#" class="footer-help-link">Go to your Settings.</a>
                        </div>
                    </div>
                    <div class="footer-help-item">
                        <span class="footer-help-icon">
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>
                        </span>
                        <div class="footer-help-content">
                            <span class="footer-help-title">Recommendation transparency</span>
                            <a href="#" class="footer-help-link">Learn more about Recommended Content.</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <span class="footer-copyright">MFStrive © 2026</span>
            </div>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>
